//------------------------------------------------------------
//  Sample file: Part of ZModeler SDK
//
//  Purpose: Create\Sphere tool.
//------------------------------------------------------------
#include <struct.h>
#include <afxcmn.h>
#include "resource.h"

DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}

DWORD CALLBACK Supports(long)
{
  return Z3D_PLUGSUPPORTS_PROCESSING;
}

DWORD CALLBACK DynamicLoading(long)
{
  return 0;
}

DWORD CALLBACK GetProcsAmount(long)
{
  return 1;
}

DWORD CALLBACK PlaceType(long num)
{
  return Z3D_PROCPLACE_TOOLBAR;
}

char* CALLBACK GetMenuFolder(long num)
{
  return "Tutorials\\Geometry Bar\0";
}

char* GetToolName(long num)
{
  if (num==0) return "Cube";
  if (num==1) return "Sphere";
  if (num==2) return "Cylinder";
  if (num==3) return "Cone";
  return NULL;
}

char* CALLBACK GetProcComment(DWORD num)
{
  return "Box\nSphere\nCyliner\nCone\n";
}


//////////////////////////////////////////////////////////////
//  void OnLoad processes creation of the corresponding toolbar.
//  and attaching of it into the main window;
DWORD CALLBACK OnLoadToolBar(
            DWORD        num,
            CToolBar**      TB,
            CWnd        *pwnd,
            HINSTANCE      AppHandle,
            HINSTANCE      DLLHandle)
{
  z3dProcsSet  *pProcs = NULL;
  CToolBar  *pTB;
  if (DLLHandle && pwnd)
  {
    pTB = new CToolBar();
    AfxSetResourceHandle(DLLHandle);// Tell system to use DLL's resources.

    pTB->CreateEx(pwnd, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
            | CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
    pTB->SetWindowText("Geometry");
    if (!pTB->LoadToolBar(IDR_GEOMETRY))
    {
      pwnd->MessageBox("Error Loading ToolBar in module ZViewBar.zmp", "Plugin Error:", MB_OK | MB_ICONEXCLAMATION);
      delete pTB;
      pTB = NULL;
      return 0;
    }
    /////// Docking Control Bar
    pTB->EnableDocking(CBRS_ALIGN_ANY);
    HCURSOR hcCreate = AfxGetApp()->LoadCursor(IDC_CREATECURSOR);    
    int i;
    TBBUTTON Button;
    for (i=0; i < pTB->GetCount(); i++)
    {//Removing buttons
      (pTB->GetToolBarCtrl()).GetButton( i, &Button);
      (pTB->GetToolBarCtrl()).DeleteButton( i);
      pProcs = new z3dProcsSet;
      pProcs->DllHandleLB    = DLLHandle;
      pProcs->DllHandleRB    = DLLHandle;

      pProcs->bAlternative  = FALSE;
      pProcs->OnLBDProc    = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("OnLButtonDown"));
      pProcs->OnLBUProc    = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("OnLButtonUp"));
      pProcs->OnMMProc    = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("OnMouseMove"));
      pProcs->OnMMLBDProc    = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("OnMouseMoveLBD"));
      pProcs->OnMMRBDProc    = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("OnMouseMoveRBD"));
      pProcs->OnRBDProc    = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("OnRButtonDown"));
      pProcs->OnRBUProc    = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("OnRButtonUp"));
      pProcs->OnPreModeProc  = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("PreMode"));
      pProcs->OnPostModeProc  = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("PostMode"));
      pProcs->OnKeyProc    = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("OnKey"));

      pProcs->hcNorm = hcCreate;
      pProcs->hcLBNorm = hcCreate;

      Button.dwData = (DWORD)(pProcs);
      (pTB->GetToolBarCtrl()).InsertButton( i, &Button);
      pTB->SetButtonStyle(i,TBBS_CHECKBOX);
    }
    
    AfxSetResourceHandle(AppHandle);// Set it back before leaving.
  }
  else
  {
    pwnd->MessageBox("Resources not found or Editor window was not created!","Internal Error:", MB_OK | MB_ICONEXCLAMATION);
    pTB = NULL;
    return 0;
  }
  if (pTB) *TB = pTB;
  return 1; //ok, dockable;
}


